'use strict';

/* --------------------------------------------------------------
 extend_order_status_modal.js 2017-11-03
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2017 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

/**
 * Extends the order status modal with a "notify-klarna-hub" checkbox.
 */
(function () {
	'use strict';

	/**
  * Used for bulk actions.
  *
  * @type {Number[]}
  */

	var selectedKlarnaHubOrderNumbers = [];

	/**
  * Initializes the module.
  *
  * @private
  */
	var init = function init() {
		var $modal = $('.modal.status');
		var $select = $('#status-dropdown');
		var $orderStatusSave = $modal.find('.btn.save');
		var moduleCodes = ['KlarnaHub', 'KlarnaPaynowHub', 'KlarnaPaylaterHub', 'KlarnaSliceitHub', 'KlarnaBanktransferHub'];

		// Add the notify-klarna-hub checkbox (hidden by default).
		var $sourceListItem = $modal.find('.single-checkbox:first').closest('li');

		var $listItem = $sourceListItem.clone(true);
		$listItem.addClass('hidden');

		var $label = $listItem.find('label');
		$label.text(KlarnaHub.Config.lang.NOTIFY_KLARNA);

		var $singleCheckbox = $listItem.find('.single-checkbox');
		var $checkbox = $listItem.find('input:checkbox');
		$checkbox.addClass('notify-klarna');
		$checkbox.on('change', function (event) {
			return $checkbox.parent().toggleClass('checked', $checkbox.prop('checked'));
		});

		$listItem.insertBefore($sourceListItem.next());

		// Bind status type change event.
		$select.on('change', function () {
			var hasCorrectStatus = $select.val() && $select.val() == KlarnaHub.Config.orderStatusShipped;
			var hasSelectedOrders = KlarnaHub.Config.orderNumber !== null || selectedKlarnaHubOrderNumbers.length;

			if (hasCorrectStatus && hasSelectedOrders) {
				$listItem.removeClass('hidden');
				$checkbox.prop('checked', true);
				$singleCheckbox.addClass('checked');
			} else {
				$listItem.addClass('hidden');
				$checkbox.prop('checked', false);
				$singleCheckbox.removeClass('checked');
			}
		});

		// Bind order status save button click event.
		$orderStatusSave.on('click', function () {
			var hasCorrectStatus = $select.val() && $select.val() == KlarnaHub.Config.orderStatusShipped;
			var hasSelectedOrders = KlarnaHub.Config.orderNumber !== null || selectedKlarnaHubOrderNumbers.length;

			if (!hasCorrectStatus || !hasSelectedOrders || !$checkbox.prop('checked')) {
				return;
			}

			var orderNumbers = selectedKlarnaHubOrderNumbers.length ? selectedKlarnaHubOrderNumbers : [KlarnaHub.Config.orderNumber];

			orderNumbers.forEach(function (orderNumber) {
				KlarnaHub.Config.orderNumber = orderNumber;
				KlarnaHub.Config.moduleCode = $table.find('tr#' + orderNumber).data('gambioHubModule');

				if ($select.val() == KlarnaHub.Config.orderStatusShipped) {
					KlarnaHub.Api.executeFullCapture();
				}
			});
		});

		var $table = $('.orders.overview table');

		$table.on('click', '.change-status, .tooltip-order-status-history', function (event) {
			var $row = $(event.target).closest('tr');
			var orderNumber = $row.data('id');
			var moduleCode = $row.data('gambioHubModule');

			if (orderNumber && moduleCode && moduleCodes.includes(moduleCode)) {
				KlarnaHub.Config.orderNumber = orderNumber;
				KlarnaHub.Config.moduleCode = moduleCode;
			} else {
				KlarnaHub.Config.orderNumber = null;
				KlarnaHub.Config.moduleCode = null;
			}
		});

		$modal.on('shown.bs.modal', function () {
			return $select.trigger('change');
		});

		$modal.on('hide.bs.modal', function () {
			KlarnaHub.Config.orderNumber = null;
			KlarnaHub.Config.moduleCode = null;
			selectedKlarnaHubOrderNumbers = [];
		});

		var $bulkAction = $('.bulk-action');

		$bulkAction.on('click', '.change-status', function () {
			selectedKlarnaHubOrderNumbers = KlarnaHub.Lib.getSelectedKlarnaHubOrderNumbers();
		});
	};

	KlarnaHub.on('ready', function () {
		return init();
	});
})();
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
